<?php /* Template Name: Home */ ?>
<?php get_header(); ?>
<section id="content-parent" role="main" class="page-parent">
    <?php
    $currentPost = $wp_query->post;
    $mainTaxonomyArgs = array('fields' => 'ids');
    $mainTaxonomyId = wp_get_post_terms($currentPost->ID, 'group', $mainTaxonomyArgs);
    $terms_args = array(
        'child_of' => $mainTaxonomyId[0]
    );
    $termsOfTaxonomyGroup = get_terms( 'group', $terms_args );
    ksort($termsOfTaxonomyGroup);
    $termsNumb = 0;
    ?>
    <?php foreach($termsOfTaxonomyGroup as $term) : ?>
        <?php $termsNumb++; ?>
        <?php
        $termClass = $term->slug;
        $termName = $term->name;
        $termID = $term->term_id;
        $postID = $post->ID;
        $args = array(
            'sort_order' => 'ASC',
            'sort_column' => 'menu_order',
            'hierarchical' => 1,
            'child_of' => $postID,
            'orderby' => 'menu_order',
            'tax_query' => array(
                array(
                    'taxonomy' => 'group',
                    'field' => 'id',
                    'terms' => $termID
                    //'orderby' => 'custom_sort',
                    //'order'=> 'ASC'
                   // 'sort_order' => 'ASC',
                   // 'sort_column' => 'menu_order'
                )
            ),
            'offset' => 0,
            'post_type' => 'page',
            'post_status' => 'publish'
        );
        $counter = 0;


       // add_filter( 'posts_orderby', 'filter_query' );

        $query = new WP_Query( $args );

       // remove_filter( 'posts_orderby', 'filter_query' );


        ?>

        <?php if ($query) : ?>

            <div class="home-content container <?php echo $termClass; ?>-in">
                <ul>
                    <div class="home-banner banner2">
                            <?php foreach( $query->posts as $page ) : ?>
                                <?php $counter++;
                                    if ($counter < 10)
                                    {
                                        $newCounter = 0 . $counter;
                                    } else {
                                        $newCounter = $counter;
                                    };
                                ?>
                                <?php $blueLabelStatus = get_field('blue_label', $page->ID); ?>
                                <?php $sliderElementLink = get_field('slider_link', $page->ID); ?>
                                <?php
                                $postThumbId = get_post_thumbnail_id($page->ID);
                                $attachmentInfo = wp_get_attachment_image_src($postThumbId, 'main-slide');
                                ?>
                                <li class="sp sp-<?php echo $termClass?> home-banner-in"
                                    <?php if($termClass != 'slider') : ?>
                                    style="background-image: url(<?php echo $attachmentInfo[0] ?>);"
                                    <?php endif; ?>>
                                    <?php if($termClass != 'slider') : ?>
                                    <div class="slide-content">
                                        <?php if($sliderElementLink) : ?>
                                            <a href="<?php echo $sliderElementLink?>">
                                        <?php endif; ?>
                                        <h1><?php echo $page->post_title; ?></h1>
                                        <p><?php echo $page->post_excerpt; ?></p>
                                        <?php if($sliderElementLink) : ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <?php elseif($termClass == 'slider') : ?>
                                    <div class="row slide-content content-in slider-content-in">
                                    <?php if ($counter % 2 == 0) : ?>   
                                    <div class="col-md-7 col-sm-12 reverse res-image">
                                            <?php echo get_the_post_thumbnail( $page->ID ); ?>
                                        </div
                                    ><?php endif; ?>
                                        <div class="col-md-5 col-sm-12 col-xs-12 reverse">
                                            <?php if($sliderElementLink) : ?>
                                                <h3 class="hslider">
                                                    <a href="<?php echo $sliderElementLink?>"><?php echo $page->post_title; ?></a>
                                                </h3>
                                            <?php else : ?>
                                                <h3><?php echo $page->post_title; ?></h3>
                                            <?php endif; ?>
                                            <div class="counter">
                                                <?php echo $newCounter; ?>
                                                <div class="revert-line"></div>
                                            </div>
                                            <div class="excrpt">
                                                <?php echo $page->post_excerpt; ?>
                                            </div>
                                            <?php if($sliderElementLink) : ?>
                                            <a href="<?php echo $sliderElementLink?>">
                                            <?php endif; ?>
                                                    <div class="know-btn"><?php echo esc_attr( get_option('translate_7') ); ?></div>
                                            <?php if($sliderElementLink) : ?>
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                        <?php if ($counter % 2 != 0) : ?>   
                                        <div class="col-md-7 col-sm-12 reverse res-image">
                                                <?php echo get_the_post_thumbnail( $page->ID ); ?>
                                            </div
                                        ><?php endif; ?>
                                        <div class="clearfix"></div>
                                    </div>
                                    <?php endif; ?>
                                </li>
                                <?php if($blueLabelStatus == true && $termClass != 'slider') : ?>
                                    <div class="banner-foot">
                                        <div class="banner-foot-in container">
                                            <h1><?php echo esc_attr( get_option('translate_2') ); ?></h1>
                                            <div class="banner-foot-content col-md-5">
                                                <?php echo esc_attr( get_option('translate_3') ); ?>
                                            </div>
                                            <div class="wrapbutt">
                                                <a class="button orng col-md-3 col-sm-4 col-xs-5" href=""><?php echo esc_attr( get_option('translate_4') ); ?></a>
                                                <input class="givenumber col-md-3 col-sm-4 col-xs-5" type="text" name="firstname" value="<?php echo esc_attr( get_option('translate_5') ); ?>" onfocus="if(this.value=='<?php echo esc_attr( get_option('translate_5') ); ?>')this.value=''" onblur="if(this.value=='')this.value='<?php echo esc_attr( get_option('translate_5') ); ?>'">
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        
                   
                    </div>
                </ul>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
    <div class="clients-aboutus ">
        <h1><?php echo esc_attr( get_option('translate_1') ); ?></h1>
        <div class="loga-bot">
                <div class="logos-wrap col-xs-12">
                            <?php
                            $args = array(
                                'post_type' => 'clients',
                                'posts_per_page' => '100'
                            );
                            $loop = new WP_Query( $args );
                            while ( $loop->have_posts() ) : $loop->the_post(); ?>
                                <div class="logo-box">
                                    <?php the_post_thumbnail(); ?>
                                </div>
                            <?php endwhile; ?>
            </div>
        </div>
    </div>
</section>
<?php get_sidebar(); ?>
<?php get_footer(); ?>