<?php
// create custom plugin settings menu
add_action('admin_menu', 'l4w_create_menu');

function l4w_create_menu() {

    //create new top-level menu
    add_menu_page('Translations', 'Translations', 'administrator', __FILE__, 'l4w_settings_page' , get_template_directory_uri().'/images/icons/translations-ico.png' );

    //call register settings function
    add_action( 'admin_init', 'register_l4w_settings' );
}


function register_l4w_settings() {
    //register our settings
    register_setting( 'l4w-settings-group', 'translate_1' );
    register_setting( 'l4w-settings-group', 'translate_2' );
    register_setting( 'l4w-settings-group', 'translate_3' );
    register_setting( 'l4w-settings-group', 'translate_4' );
    register_setting( 'l4w-settings-group', 'translate_5' );
    register_setting( 'l4w-settings-group', 'translate_6' );
    register_setting( 'l4w-settings-group', 'translate_7' );
    register_setting( 'l4w-settings-group', 'translate_8' );
    register_setting( 'l4w-settings-group', 'translate_9' );
    register_setting( 'l4w-settings-group', 'translate_10' );
    register_setting( 'l4w-settings-group', 'translate_11' );
    register_setting( 'l4w-settings-group', 'translate_12' );
    register_setting( 'l4w-settings-group', 'translate_13' );
    register_setting( 'l4w-settings-group', 'translate_14' );
    register_setting( 'l4w-settings-group', 'translate_15' );
    register_setting( 'l4w-settings-group', 'translate_16' );
    register_setting( 'l4w-settings-group', 'translate_17' );
    register_setting( 'l4w-settings-group', 'translate_18' );
    register_setting( 'l4w-settings-group', 'translate_19' );
    register_setting( 'l4w-settings-group', 'translate_20' );
    register_setting( 'l4w-settings-group', 'translate_21' );
    register_setting( 'l4w-settings-group', 'translate_22' );
    register_setting( 'l4w-settings-group', 'translate_23' );
    register_setting( 'l4w-settings-group', 'translate_24' );
    
    
    
    
}

function l4w_settings_page() {
    ?>
    <div class="wrap">
        <h2><?php _e('Translations for theme'); ?></h2>

        <form method="post" action="options.php">
            <?php settings_fields( 'l4w-settings-group' ); ?>
            <?php do_settings_sections( 'l4w-settings-group' ); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><?php _e('Klienci o nas', 'l4w'); ?></th>
                    <td><input type="text" name="translate_1" value="<?php echo esc_attr( get_option('translate_1') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Jesteś zainteresowany <strong>zakupem?</strong>', 'l4w'); ?></th>
                    <td><input type="text" name="translate_2" value="<?php echo esc_attr( get_option('translate_2') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas mattis sapien in egestas fringilla.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_3" value="<?php echo esc_attr( get_option('translate_3') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('sprawdź cenę', 'l4w'); ?></th>
                    <td><input type="text" name="translate_4" value="<?php echo esc_attr( get_option('translate_4') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Podaj lb. użytkowników', 'l4w'); ?></th>
                    <td><input type="text" name="translate_5" value="<?php echo esc_attr( get_option('translate_5') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Czy wiesz że wiele organizacji przekonaliśmy do zalet naszego rozwiązania.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_6" value="<?php echo esc_attr( get_option('translate_6') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Poznaj kolejny krok','l4w'); ?></th>
                    <td><input type="text" name="translate_7" value="<?php echo esc_attr( get_option('translate_7') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e( '© Copyright iQ Solution Sp. z o.o. Wszelkie prawa zastrzeżone', 'l4w' ); ?></th>
                    <td><input type="text" name="translate_8" value="<?php echo esc_attr( get_option('translate_8') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Jeżeli nadal nie wierzysz że to może być aż tak łatwe wyślij do nas swoje dane kontaktowe a&nbsp;my udostępnimy Ci wersję demo.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_9" value="<?php echo esc_attr( get_option('translate_9') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('<strong>Przekonałeś się</strong><br />do naszego<br />rozwiązania?', 'l4w'); ?></th>
                    <td><input type="text" name="translate_10" value="<?php echo esc_attr( get_option('translate_10') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Wyślij', 'l4w') ?></th>
                    <td><input type="text" name="translate_11" value="<?php echo esc_attr( get_option('translate_11') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Wiadomość:', 'l4w'); ?></th>
                    <td><input type="text" name="translate_12" value="<?php echo esc_attr( get_option('translate_12') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Email', 'l4w'); ?></th>
                    <td><input type="text" name="translate_13" value="<?php echo esc_attr( get_option('translate_13') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Imię:', 'l4w'); ?></th>
                    <td><input type="text" name="translate_14" value="<?php echo esc_attr( get_option('translate_14') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Wystąpił błąd.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_15" value="<?php echo esc_attr( get_option('translate_15') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Dziękujemy, email został wysłany poprawnie.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_16" value="<?php echo esc_attr( get_option('translate_16') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Proszę podać swoje imię.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_17" value="<?php echo esc_attr( get_option('translate_17') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Proszę podać adres Email.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_18" value="<?php echo esc_attr( get_option('translate_18') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Podany adres Email jest nieprawidłowy.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_19" value="<?php echo esc_attr( get_option('translate_19') ); ?>" /></td>
                </tr>

                <tr valign="top">
                    <th scope="row"><?php _e('Prosze wpisać wiadomość.', 'l4w'); ?></th>
                    <td><input type="text" name="translate_20" value="<?php echo esc_attr( get_option('translate_20') ); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e('Skontaktuj się', 'l4w'); ?></th>
                    <td><input type="text" name="translate_21" value="<?php echo esc_attr( get_option('translate_21') ); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e('contact-url', 'l4w'); ?></th>
                    <td><input type="text" name="translate_22" value="<?php echo esc_attr( get_option('translate_22') ); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e('Kontakt', 'l4w'); ?></th>
                    <td><input type="text" name="translate_23" value="<?php echo esc_attr( get_option('translate_23') ); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e('Formularz kontaktowy', 'l4w'); ?></th>
                    <td><input type="text" name="translate_24" value="<?php echo esc_attr( get_option('translate_24') ); ?>" /></td>
                </tr>
            </table>

            <?php submit_button(); ?>

        </form>
    </div>
<?php } ?>