<?php
/**
 * Light4website
 *
 * @copyright  Copyright(c) 2015 light4website (http://light4website.com)
 * @license    http://light4website.com/license/license.txt
 */

add_action('init', 'createGroupPageTaxonomy' );

function createGroupPageTaxonomy()
{

    $labels = array(
        'name'              => _x( 'Group', 'taxonomy general name' ),
        'singular_name'     => _x( 'Groups', 'taxonomy singular name' ),
        'search_items'      => __( 'Search Groups' ),
        'all_items'         => __( 'All Groups' ),
        'parent_item'       => __( 'Parent Group' ),
        'parent_item_colon' => __( 'Parent Group:' ),
        'edit_item'         => __( 'Edit Group' ),
        'update_item'       => __( 'Update Group' ),
        'add_new_item'      => __( 'Add New Group' ),
        'new_item_name'     => __( 'New Group Name' ),
        'menu_name'         => __( 'Group' ),
    );

    $args = array(
        'public'            => true,
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'group' ),
    );

    register_taxonomy( 'group', array( 'page' ), $args );
}