<?php

/**
 * load text domain for wp translations
 */

load_theme_textdomain('l4w', get_template_directory() . '/languages');

/**
 * define theme root url
 */

if(!defined('L4W_THEME_DIR')) {
    define ('L4W_THEME_DIR', get_theme_root().'/'.get_template().'/');
}

if(!defined('L4W_THEME_URL')) {
    define ('L4W_THEME_URL', WP_CONTENT_URL.'/themes/'.get_template().'/');
}

/**
 * load script with custom taxonomies for wordpress pages
 */

require_once L4W_THEME_DIR.'functions/core/page/custom-taxonomies.php';

/**
 * add excerpts for wordpress pages
 */

require_once L4W_THEME_DIR.'functions/core/page/page-excerpts.php';

/**
 * add opinions posttype about company to admin
 */

require_once L4W_THEME_DIR.'functions/core/posttypes/opinions.php';

/**
 * add company clients posttype to admin
 */

require_once L4W_THEME_DIR.'functions/core/posttypes/clients.php';

/**
 * add post thumbnails support
 */

require_once L4W_THEME_DIR.'functions/core/images.php';

/**
 * add translations menu page
 */

require_once L4W_THEME_DIR.'options/translations.php';

/**
 * other scripts
 */

add_action( 'after_setup_theme', 'blankslate_setup' );
function blankslate_setup()
{
load_theme_textdomain( 'blankslate', get_template_directory() . '/languages' );
add_theme_support( 'automatic-feed-links' );

global $content_width;
if ( ! isset( $content_width ) ) $content_width = 640;
register_nav_menus(
array( 'main-menu' => __( 'Main Menu', 'l4w' ) )
);
}
add_action( 'wp_enqueue_scripts', 'blankslate_load_scripts' );
function blankslate_load_scripts()
{
wp_enqueue_script( 'jquery' );
}
add_action( 'comment_form_before', 'blankslate_enqueue_comment_reply_script' );
function blankslate_enqueue_comment_reply_script()
{
if ( get_option( 'thread_comments' ) ) { wp_enqueue_script( 'comment-reply' ); }
}
add_filter( 'the_title', 'blankslate_title' );
function blankslate_title( $title ) {
if ( $title == '' ) {
return '&rarr;';
} else {
return $title;
}
}
add_filter( 'wp_title', 'blankslate_filter_wp_title' );
function blankslate_filter_wp_title( $title )
{
return $title . esc_attr( get_bloginfo( 'name' ) );
}
add_action( 'widgets_init', 'blankslate_widgets_init' );
function blankslate_widgets_init()
{
register_sidebar( array (
'name' => __( 'Sidebar Widget Area', 'l4w' ),
'id' => 'primary-widget-area',
'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
'after_widget' => "</li>",
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
}
function blankslate_custom_pings( $comment )
{
$GLOBALS['comment'] = $comment;
?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>"><?php echo comment_author_link(); ?></li>
<?php 
}
add_filter( 'get_comments_number', 'blankslate_comments_number' );
function blankslate_comments_number( $count )
{
if ( !is_admin() ) {
global $id;
$comments_by_type = &separate_comments( get_comments( 'status=approve&post_id=' . $id ) );
return count( $comments_by_type['comment'] );
} else {
return $count;
}
}

remove_filter( 'the_content', 'wpautop' );
remove_filter( 'the_excerpt', 'wpautop' );
